document.addEventListener("DOMContentLoaded", function () {
    const contentContainer = document.getElementById("content");
    const loadContentButton = document.getElementById("load2");

    loadContentButton.addEventListener("click", function () {
        // Make a GET request to the dummy server (JSONPlaceholder) to fetch multiple posts
        fetch('https://jsonplaceholder.typicode.com/posts')
            .then(response => response.json())
            .then(posts => {
                // Clear existing content
                contentContainer.innerHTML = '';

                // Iterate through each post and add it to the content container
                posts.forEach(post => {
                    const postElement = document.createElement("div");
                    postElement.innerHTML = `
                        <h2>${post.title}</h2>
                        <p>${post.body}</p>
                    `;
                    contentContainer.appendChild(postElement);
                });
            })
            .catch(error => console.error('Error:', error));
    });
});
